<?php
// Configuración de la cabecera (Header) de la respuesta
header('Content-Type: application/json; charset=utf-8');
// Permite solicitudes CORS (necesario si pruebas desde un emulador o dispositivo)
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

// Incluye el archivo de conexión
require_once 'db_connect.php';

// 1. Leer los datos JSON enviados desde la aplicación Android
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// 2. Extraer los datos y verificar que los campos obligatorios existan
$nombres = $data['nombres'] ?? '';
$apellido_paterno = $data['apellido_paterno'] ?? NULL; // Puede ser NULL si no se envía
$apellido_materno = $data['apellido_materno'] ?? NULL;
$documento_identidad = $data['documento_identidad'] ?? '';
$fecha_nacimiento = $data['fecha_nacimiento'] ?? NULL;
$correo_electronico = $data['correo_electronico'] ?? NULL;
$tipo_documento = $data['tipo_documento'] ?? 'DNI'; // Asumimos DNI si no se especifica

// Validación básica (campos NOT NULL en la DB)
if (empty($nombres) || empty($documento_identidad)) {
    echo json_encode(array("status" => "error", "message" => "Los campos 'nombres' y 'documento_identidad' son obligatorios."));
    $conn->close();
    exit();
}

// 3. Preparar la consulta SQL (usando sentencias preparadas para seguridad)
$sql = "INSERT INTO estudiantes (nombres, apellido_paterno, apellido_materno, documento_identidad, fecha_nacimiento, correo_electronico, tipo_documento) 
        VALUES (?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);

if ($stmt === false) {
    echo json_encode(array("status" => "error", "message" => "Error al preparar la consulta: " . $conn->error));
    $conn->close();
    exit();
}

// 4. Vincular los parámetros ('sssssss' indica 7 strings o 's' para string, 'd' para date)
// Utilizamos 's' para todos los campos ya que PHP los manejará como strings de entrada.
$stmt->bind_param("sssssss", $nombres, $apellido_paterno, $apellido_materno, $documento_identidad, $fecha_nacimiento, $correo_electronico, $tipo_documento);

// 5. Ejecutar la consulta
if ($stmt->execute()) {
    $response = array("status" => "success", "message" => "Estudiante registrado exitosamente.", "id_insertado" => $conn->insert_id);
} else {
    // Manejo de errores específicos (ej. documento_identidad duplicado)
    $error_message = $stmt->error;
    if (strpos($error_message, 'Duplicate entry') !== false) {
         $error_message = "El Documento de Identidad ya existe.";
    }
    $response = array("status" => "error", "message" => "Error al registrar: " . $error_message);
}

// 6. Cerrar sentencia y conexión
$stmt->close();
$conn->close();

// 7. Devolver la respuesta en formato JSON
echo json_encode($response);
?>